#include <mpi.h>   /* PROVIDES THE BASIC MPI DEFINITION AND TYPES */
#include <omp.h>
#include  <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  
  int my_rank; 
  int size;
  int i,j;
  int a[5][10];  
  int buff[10];
  int *ptr;
  int source;
  int num_iterations;
  MPI_Status status;
  MPI_Init(&argc, &argv); /*START MPI */



/*DETERMINE RANK OF THIS PROCESSOR*/
  MPI_Comm_rank(MPI_COMM_WORLD, &my_rank); 

 /*DETERMINE TOTAL NUMBER OF PROCESSORS*/
  MPI_Comm_size(MPI_COMM_WORLD, &size);

  if(my_rank ==0) {

    //Initialize the array at the Master

    printf("Before the array was sent to the slaves:\n");
    for(i=0;i<5;i++)
    {
     for(j=0;j<10;j++)
     {
         a[i][j] = (i*10)+j;
         printf("%d ",a[i][j]);
     } 
      printf("\n");
    } 


    //Send the array values to the slaves
    for(i=1;i<size;i++){
       ptr = (int *) a + ( (i-1) * 10);
       MPI_Send(ptr,10, MPI_INT,i,0,MPI_COMM_WORLD);
    }



    //Receive the computed values from the slaves
    for(i=1;i<size;i++)
    {
       MPI_Recv(buff,10,MPI_INT,MPI_ANY_SOURCE,0,MPI_COMM_WORLD,&status);
       source = status.MPI_SOURCE; 
       ptr = (int *) a + ( (source-1) * 10);
       for(j=0;j<10;j++)
       {
         ptr[j] = buff[j];
       }
    }


    printf("After the array was reveived from the slaves:\n");
    //Print the final output

    for(i=0;i<5;i++)
    {
     for(j=0;j<10;j++)
     {         
       printf("%d ",a[i][j]);
     } 
      printf("\n");
    } 

  }



  else
  {
    ptr = (int *) a + ( (my_rank-1) * 10);
    MPI_Recv(ptr,10,MPI_INT,0,0,MPI_COMM_WORLD,&status);
     //printf("This is slave: %d\n",my_rank);

    #pragma omp parallel for shared(ptr)
     for(j=0;j<10;j++)
     {
        num_iterations = ptr[j];
        for(i=0;i<num_iterations;i++)
        {
          ptr[j]++;
        }
 
     } 
     MPI_Send(ptr,10,MPI_INT,0,0,MPI_COMM_WORLD);
   
   }

  MPI_Finalize();  /* EXIT MPI */
  
}
